<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Prestige Home - Your Trusted Real Estate Partner</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
  <style>
    /* Custom Styles */
    body {
      font-family: 'Poppins', sans-serif;
      color: #333;
      background-color: #f4f4f4;
    }

    h1, h2, h3, h4 {
      color: #333;
    }

    p {
      line-height: 1.6;
    }

    .hero {
      background: url('https://images.unsplash.com/photo-1564013799919-ab600027ffc6?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80') no-repeat center center/cover;
      color: #fff;
      padding: 150px 0;
      text-align: center;
    }

    .hero h1 {
      font-size: 48px;
      margin-bottom: 20px;
      animation: fadeIn 2s ease-in-out;
    }

    .hero p {
      font-size: 20px;
      margin-bottom: 30px;
      animation: fadeIn 3s ease-in-out;
    }

    .hero .btn {
      background: #ff6f61;
      color: #fff;
      padding: 15px 30px;
      text-decoration: none;
      border-radius: 5px;
      font-size: 18px;
      animation: fadeIn 4s ease-in-out;
    }

    .about img, .history img {
      border-radius: 10px;
      animation: slideInLeft 1s ease-in-out;
    }

    .about .text, .history .text {
      animation: slideInRight 1s ease-in-out;
    }

    .services .card {
      transition: transform 0.3s ease;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
    }

    .services .card:hover {
      transform: translateY(-10px);
    }

    .testimonials .card img {
      width: 100px;
      height: 100px;
      border-radius: 50%;
      margin-bottom: 20px;
    }

    footer {
      background: #333;
      color: #fff;
      padding: 40px 0;
      text-align: center;
    }

    footer .social-links a {
      color: #fff;
      margin: 0 10px;
      font-size: 20px;
    }

    /* Animations */
    @keyframes fadeIn {
      from { opacity: 0; }
      to { opacity: 1; }
    }

    @keyframes slideInLeft {
      from { transform: translateX(-100%); }
      to { transform: translateX(0); }
    }

    @keyframes slideInRight {
      from { transform: translateX(100%); }
      to { transform: translateX(0); }
    }
  </style>
</head>
<body>
  <!-- Header Section -->
  <header class="bg-dark">
    <div class="container">
      <nav class="navbar navbar-expand-lg navbar-dark">
        <a class="navbar-brand" href="#">Prestige Home</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
          <ul class="navbar-nav ms-auto">
            <li class="nav-item"><a class="nav-link" href="#about">About Us</a></li>
            <li class="nav-item"><a class="nav-link" href="#services">Services</a></li>
            <li class="nav-item"><a class="nav-link" href="#testimonials">Testimonials</a></li>
            <li class="nav-item"><a class="nav-link" href="#history">History</a></li>
          </ul>
        </div>
      </nav>
    </div>
  </header>

  <!-- Hero Section -->
  <section class="hero">
    <div class="container">
      <h1 class="display-4">Your Trusted Real Estate Partner</h1>
      <p class="lead">At Prestige Home, we provide expert real estate services to help you find your dream home or investment property. With years of experience and a commitment to excellence, we are here to guide you every step of the way.</p>
      <a href="#services" class="btn btn-primary btn-lg">Explore Our Services</a>
    </div>
  </section>

  <!-- About Us Section -->
  <section id="about" class="about py-5 bg-white">
    <div class="container">
      <h2 class="text-center mb-5">About Us</h2>
      <div class="row align-items-center">
        <div class="col-md-6">
          <img src="https://images.unsplash.com/photo-1552664730-d307ca884978?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80" alt="About Us" class="img-fluid">
        </div>
        <div class="col-md-6">
          <p>Prestige Home was founded in 2005 with a mission to provide reliable and transparent real estate services to individuals and businesses. Over the years, we have grown into a trusted name in the real estate industry, serving clients across the globe.</p>
          <p>Our team of experienced real estate agents and advisors is dedicated to helping you find your dream home or investment property. We believe in building long-term relationships with our clients by offering personalized solutions tailored to their unique needs.</p>
          <p>At Prestige Home, we pride ourselves on our commitment to integrity, transparency, and excellence. Whether you're buying, selling, or renting, we are here to help you navigate the complexities of the real estate market and achieve your goals.</p>
          <p>Our core values include trust, innovation, and client satisfaction. We strive to create a positive impact on our clients' lives by providing them with the tools and knowledge they need to succeed in their real estate journey.</p>
        </div>
      </div>
    </div>
  </section>

  <!-- Services Section -->
  <section id="services" class="services py-5 bg-light">
    <div class="container">
      <h2 class="text-center mb-5">Our Services</h2>
      <div class="row g-4">
        <div class="col-md-4">
          <div class="card h-100 text-center p-4">
            <i class="fas fa-home fa-3x mb-3 text-primary"></i>
            <h3>Buying a Home</h3>
            <p>We help you find your dream home with our extensive listings and expert guidance. Our team will assist you every step of the way, from searching to closing.</p>
          </div>
        </div>
        <div class="col-md-4">
          <div class="card h-100 text-center p-4">
            <i class="fas fa-hand-holding-usd fa-3x mb-3 text-primary"></i>
            <h3>Selling a Home</h3>
            <p>We provide comprehensive services to help you sell your home quickly and at the best price. Our team will handle everything from staging to negotiations.</p>
          </div>
        </div>
        <div class="col-md-4">
          <div class="card h-100 text-center p-4">
            <i class="fas fa-building fa-3x mb-3 text-primary"></i>
            <h3>Investment Properties</h3>
            <p>We offer expert advice and services to help you find the best investment properties. Our team will help you maximize your returns and minimize risks.</p>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Testimonials Section -->
  <section id="testimonials" class="testimonials py-5 bg-white">
    <div class="container">
      <h2 class="text-center mb-5">What Our Clients Say</h2>
      <div class="row g-4">
        <div class="col-md-6">
          <div class="card h-100 text-center p-4">
            <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=crop&w=634&q=80" alt="Client 1" class="img-fluid rounded-circle mb-3">
            <p>"Prestige Home helped me find my dream home. Their team is highly professional and always goes the extra mile to ensure client satisfaction."</p>
            <h4 class="text-primary">- John Doe, Homebuyer</h4>
          </div>
        </div>
        <div class="col-md-6">
          <div class="card h-100 text-center p-4">
            <img src="https://images.unsplash.com/photo-1494790108377-be9c29b29330?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=crop&w=634&q=80" alt="Client 2" class="img-fluid rounded-circle mb-3">
            <p>"Their expertise in real estate investments has been invaluable to my portfolio. I highly recommend Prestige Home to anyone looking for reliable real estate services."</p>
            <h4 class="text-primary">- Jane Smith, Investor</h4>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- History Section -->
  <section id="history" class="history py-5 bg-light">
    <div class="container">
      <h2 class="text-center mb-5">Our History</h2>
      <div class="row align-items-center">
        <div class="col-md-6">
          <img src="https://images.unsplash.com/photo-1522071820081-009f0129c71c?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80" alt="History" class="img-fluid">
        </div>
        <div class="col-md-6">
          <p>Prestige Home was established in 2005 with a vision to revolutionize the real estate industry. Over the years, we have grown into a global leader in real estate services, serving clients in over 30 countries.</p>
          <p>Our journey has been marked by innovation, dedication, and a commitment to excellence. From our humble beginnings in a small office to our current state-of-the-art headquarters, we have always strived to push the boundaries of what's possible.</p>
          <p>Today, Prestige Home is recognized as a trusted partner for individuals and businesses looking to achieve their real estate goals. We continue to innovate and adapt to the ever-changing real estate landscape, ensuring that our clients stay ahead of the curve.</p>
          <p>As we look to the future, we remain committed to our mission of empowering our clients through real estate expertise and personalized solutions. Join us on our journey to real estate success.</p>
        </div>
      </div>
    </div>
  </section>

  <!-- Footer Section -->
  <footer class="bg-dark text-white">
    <div class="container text-center py-4">
      <p>&copy; 2023 Prestige Home. All rights reserved.</p>
      <div class="social-links">
        <a href="#" class="text-white mx-2"><i class="fab fa-facebook"></i></a>
        <a href="#" class="text-white mx-2"><i class="fab fa-twitter"></i></a>
        <a href="#" class="text-white mx-2"><i class="fab fa-linkedin"></i></a>
      </div>
    </div>
  </footer>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
  <!-- Custom JS -->
  <script>
    window.addEventListener('scroll', () => {
      const elements = document.querySelectorAll('.about, .history');
      elements.forEach(el => {
        const rect = el.getBoundingClientRect();
        if (rect.top < window.innerHeight * 0.8) {
          el.style.opacity = 1;
          el.style.transform = 'translateX(0)';
        }
      });
    });
  </script>
</body>
</html>
